// Copyright (C) 2017 Klaralvdalens Datakonsult AB (KDAB).
// SPDX-License-Identifier: LicenseRef-Qt-Commercial

#ifndef QT3DANIMATION_QANIMATIONASPECT_H
#define QT3DANIMATION_QANIMATIONASPECT_H

#include <Qt3DAnimation/qt3danimation_global.h>
#include <Qt3DCore/qabstractaspect.h>

QT_BEGIN_NAMESPACE

namespace Qt3DAnimation {

class QAnimationAspectPrivate;

class Q_3DANIMATIONSHARED_EXPORT QAnimationAspect : public Qt3DCore::QAbstractAspect
{
    Q_OBJECT
public:
    explicit QAnimationAspect(QObject *parent = nullptr);
    ~QAnimationAspect();

private:
    std::vector<Qt3DCore::QAspectJobPtr> jobsToExecute(qint64 time) override;

    Q_DECLARE_PRIVATE(QAnimationAspect)
    explicit QAnimationAspect(QAnimationAspectPrivate &dd, QObject *parent);
};

} // namespace Qt3DAnimation

QT_END_NAMESPACE

#endif // QT3DANIMATION_QANIMATIONASPECT_H
